/*
 * Decompiled with CFR 0.152.
 */
package net.ogris.ampcontrol;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ogris.ampcontrol.Apple;

final class Main
extends JFrame
implements Runnable,
ChangeListener {
    protected static final String TITLE = "Amp Control";
    protected static final String VERSION = "0.2";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String[][] INPUTLABELS = new String[][]{{"10", "DVD"}, {"00", "VCR/DVR"}, {"01", "CBL/SAT"}, {"02", "GAME/TV"}, {"03", "AUX1"}, {"04", "AUX2"}, {"20", "TAPE"}, {"24", "TUNER"}, {"23", "CD"}, {"22", "PHONO"}, {"28", "NET/USB"}};
    private static final int MAXVOLUME = 50;
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private final List<String> events = Collections.synchronizedList(new ArrayList());
    private final JTextField hostField = new JTextField(this.prefs.get("amphost", "onkyo"));
    private final JTextField portField = new JTextField(this.prefs.get("ampport", "60128"));
    private final JTextField volumeField = new JTextField(Integer.toString(this.prefs.getInt("volume", 0)));
    private final JToggleButton connectButton = new JToggleButton("Connect");
    private final JToggleButton powerButton = new JToggleButton("Power");
    private final JButton minusButton = new JButton("-");
    private final JButton plusButton = new JButton("+");
    private final JSlider volumeSlider = new JSlider(0, 50, this.prefs.getInt("volume", 0));
    private final JToggleButton muteButton = new JToggleButton("Mute");
    private final JRadioButton[] inputButtons = new JRadioButton[INPUTLABELS.length];
    private final JTextField[] inputFields = new JTextField[INPUTLABELS.length];
    private Thread thread;
    private Socket socket;
    private boolean connected;

    Main() {
        Main parent = this;
        JFrame.setDefaultLookAndFeelDecorated(true);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Class.forName("com.apple.eawt.Application").newInstance();
            Apple.setUI(parent);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setIconImage(new ImageIcon(Main.class.getResource("/ampcontrol32.png")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public final void windowClosing(WindowEvent e) {
                Main.this.stopThread();
                Main.this.savePreferences();
                System.exit(0);
            }
        });
        JPanel ampPanel = new JPanel();
        ampPanel.setBorder(BorderFactory.createTitledBorder("Address"));
        JLabel colon = new JLabel(":");
        colon.setPreferredSize(new Dimension(5, 22));
        this.portField.setToolTipText("default: 60128");
        this.connectButton.addActionListener(new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                if (Main.this.connectButton.isSelected()) {
                    Main.this.startThread();
                } else {
                    Main.this.stopThread();
                }
            }
        });
        GroupLayout layout = new GroupLayout(ampPanel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.hostField, -2, -2, Short.MAX_VALUE).addComponent(colon).addComponent(this.portField, -2, -2, -2).addComponent(this.connectButton));
        layout.setVerticalGroup(layout.createBaselineGroup(false, false).addComponent(this.hostField).addComponent(colon).addComponent(this.portField).addComponent(this.connectButton));
        ampPanel.setLayout(layout);
        JPanel volumePanel = new JPanel();
        volumePanel.setBorder(BorderFactory.createTitledBorder("Volume"));
        this.volumeSlider.addChangeListener(parent);
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setPaintTrack(true);
        this.volumeSlider.setMajorTickSpacing(10);
        this.volumeSlider.setMinorTickSpacing(2);
        this.minusButton.addActionListener(new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                Main.this.volumeSlider.setValue(Main.this.volumeSlider.getValue() - 1);
            }
        });
        this.volumeField.setHorizontalAlignment(0);
        this.volumeField.addActionListener(new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                try {
                    Main.this.volumeSlider.setValue(Integer.parseInt(Main.this.volumeField.getText()));
                }
                catch (Exception ex) {
                    Main.this.showError("Invalid volume", "Invalid volume " + Main.this.volumeField.getText() + " (" + ex + ")");
                }
            }
        });
        this.plusButton.addActionListener(new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                Main.this.volumeSlider.setValue(Main.this.volumeSlider.getValue() + 1);
            }
        });
        this.muteButton.addActionListener(new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                Main.this.events.add("AMT0" + (Main.this.muteButton.isSelected() ? "1" : "0"));
            }
        });
        this.powerButton.addActionListener(new AbstractAction(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                Main.this.events.add("PWR0" + (Main.this.powerButton.isSelected() ? "1" : "0"));
            }
        });
        layout = new GroupLayout(volumePanel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.volumeSlider, -2, -2, Short.MAX_VALUE).addComponent(this.minusButton).addComponent(this.volumeField, -2, this.volumeField.getFont().getSize() * 3, -2).addComponent(this.plusButton).addGroup(layout.createParallelGroup().addComponent(this.muteButton, -2, -2, Short.MAX_VALUE).addComponent(this.powerButton, -2, -2, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.volumeSlider).addComponent(this.minusButton).addComponent(this.volumeField, -2, -2, -2).addComponent(this.plusButton).addGroup(layout.createSequentialGroup().addComponent(this.muteButton).addComponent(this.powerButton)));
        volumePanel.setLayout(layout);
        JPanel inputPanel = new JPanel();
        inputPanel.setBorder(BorderFactory.createTitledBorder("Input"));
        inputPanel.setLayout(new GridLayout((INPUTLABELS.length + 2) / 3, 3));
        ButtonGroup inputGroup = new ButtonGroup();
        for (int i = 0; i < INPUTLABELS.length; ++i) {
            JPanel panel = new JPanel();
            this.inputButtons[i] = new JRadioButton();
            this.inputButtons[i].setName("SLI" + INPUTLABELS[i][0]);
            this.inputButtons[i].addActionListener(new AbstractAction(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    Main.this.events.add(((JRadioButton)e.getSource()).getName());
                }
            });
            inputGroup.add(this.inputButtons[i]);
            this.inputFields[i] = new JTextField(this.prefs.get("input" + INPUTLABELS[i][0], INPUTLABELS[i][1]));
            this.inputFields[i].setToolTipText("default: " + INPUTLABELS[i][1]);
            layout = new GroupLayout(panel);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setVerticalGroup(layout.createBaselineGroup(false, false).addComponent(this.inputButtons[i]).addComponent(this.inputFields[i]));
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.inputButtons[i]).addComponent(this.inputFields[i]));
            panel.setLayout(layout);
            inputPanel.add(panel);
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.getContentPane().add(ampPanel);
        this.getContentPane().add(volumePanel);
        this.getContentPane().add(inputPanel);
        this.setDefaultCloseOperation(0);
        this.setTitle(TITLE);
        this.setResizable(false);
        this.setConnected(false);
        this.pack();
    }

    protected final void savePreferences() {
        this.prefs.put("amphost", this.hostField.getText());
        this.prefs.put("ampport", this.portField.getText());
        this.prefs.putInt("volume", this.volumeSlider.getValue());
        for (int i = 0; i < INPUTLABELS.length; ++i) {
            this.prefs.put("input" + INPUTLABELS[i][0], this.inputFields[i].getText());
        }
    }

    @Override
    public final void stateChanged(ChangeEvent e) {
        this.volumeField.setText(Integer.toString(this.volumeSlider.getValue()));
        if (!this.volumeSlider.getValueIsAdjusting()) {
            this.events.add("MVL" + String.format("%02X", this.volumeSlider.getValue()));
        }
    }

    private void setVolume(int volume) {
        this.volumeSlider.removeChangeListener(this);
        this.volumeField.setText(Integer.toString(volume));
        this.volumeSlider.setValue(volume);
        this.volumeSlider.addChangeListener(this);
    }

    private void startThread() {
        this.setConnected(true);
        this.events.clear();
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void stopThread() {
        this.connected = false;
    }

    private void setConnected(boolean connected) {
        this.connected = connected;
        this.connectButton.setSelected(connected);
        this.hostField.setEnabled(!connected);
        this.portField.setEnabled(!connected);
        this.powerButton.setEnabled(connected);
        this.volumeSlider.setEnabled(connected);
        this.minusButton.setEnabled(connected);
        this.volumeField.setEnabled(connected);
        this.plusButton.setEnabled(connected);
        this.muteButton.setEnabled(connected);
        for (int i = 0; i < INPUTLABELS.length; ++i) {
            this.inputButtons[i].setEnabled(connected);
        }
    }

    private void sendAndReceive() {
        int port;
        try {
            port = Integer.parseInt(this.portField.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid port: " + this.portField.getText(), "Invalid port", 0);
            return;
        }
        try {
            this.socket = new Socket(this.hostField.getText(), port);
        }
        catch (Exception e) {
            this.showError("Cannot connect", "Cannot connect to " + this.hostField.getText() + ":" + port + ":" + NEWLINE + NEWLINE + e);
            return;
        }
        if (!(this.send("PWRQSTN") && this.send("MVLQSTN") && this.send("AMTQSTN") && this.send("SLIQSTN"))) {
            return;
        }
        while (this.connected) {
            if (!this.events.isEmpty() && !this.send(this.events.remove(0))) {
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.receive()) continue;
            return;
        }
    }

    @Override
    public final void run() {
        this.sendAndReceive();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                Main.this.setConnected(false);
            }
        });
    }

    private boolean send(String command) {
        byte[] cmd = command.getBytes();
        int len = 2 + cmd.length + 1;
        byte[] data = new byte[16 + len];
        data[0] = 73;
        data[1] = 83;
        data[2] = 67;
        data[3] = 80;
        data[4] = 0;
        data[5] = 0;
        data[6] = 0;
        data[7] = 16;
        data[11] = (byte)(len % 256);
        data[10] = (byte)((len /= 256) % 256);
        data[9] = (byte)((len /= 256) % 256);
        data[8] = (byte)((len /= 256) % 256);
        len /= 256;
        data[12] = 1;
        data[13] = 0;
        data[14] = 0;
        data[15] = 0;
        data[16] = 33;
        data[17] = 49;
        System.arraycopy(cmd, 0, data, 18, cmd.length);
        data[data.length - 1] = 13;
        try {
            this.socket.getOutputStream().write(data);
        }
        catch (Exception e) {
            this.showError("Cannot send", "Cannot send command '" + command + "':" + NEWLINE + NEWLINE + e);
            return false;
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    private boolean receive() {
        int len;
        byte[] data;
        int datalen;
        try {
            if (datalen <= 0) {
                return true;
            }
            data = new byte[datalen];
            this.socket.getInputStream().read(data);
        }
        catch (Exception e) {
            this.showError("Cannot receive", "Cannot receive data:" + NEWLINE + NEWLINE + e);
            return false;
        }
        for (datalen = this.socket.getInputStream().available(); datalen > 0; datalen -= len + 16) {
            if (datalen <= 20) {
                this.showError("Bogus packet", "Received only " + datalen + " bytes from receiver - need >20");
                return false;
            }
            if (data[0] != 73 || data[1] != 83 || data[2] != 67 || data[3] != 80 || data[4] != 0 || data[5] != 0 || data[6] != 0 || data[7] != 16 || data[12] != 1 || data[13] != 0 || data[14] != 0 || data[15] != 0 || data[16] != 33 || data[17] != 49 || data[datalen - 2] != 26 || data[datalen - 1] != 13) {
                this.showError("Bogus packet", "Received improper packet");
                return false;
            }
            len = data[8] * 256 * 256 * 256 + data[9] * 256 * 256 + data[10] * 256 + data[11];
            if (len + 16 > datalen) {
                this.showError("Bogus packet", "Receiver claims command length is " + len + " bytes - must be " + (datalen - 16) + " as packet is " + datalen + " bytes");
                return false;
            }
            final String cmd = new String(data, 18, len - 4);
            if ("PWR00".equals(cmd) || "PWR01".equals(cmd)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        Main.this.powerButton.setSelected(cmd.charAt(4) == '1');
                    }
                });
            } else if (cmd.startsWith("MVL")) {
                int newVolume;
                String volume = cmd.substring(3);
                try {
                    newVolume = Integer.parseInt(volume, 16);
                }
                catch (Exception e) {
                    this.showError("Invalid volume", "Receiver send invalid master volume " + volume + " (" + e + ")");
                    return false;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        Main.this.setVolume(newVolume);
                    }
                });
            } else if ("AMT00".equals(cmd) || "AMT01".equals(cmd)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        Main.this.muteButton.setSelected(cmd.charAt(4) == '1');
                    }
                });
            } else if (cmd.startsWith("SLI")) {
                int i;
                String input = cmd.substring(3);
                for (i = INPUTLABELS.length - 1; i >= 0; --i) {
                    if (!INPUTLABELS[i][0].equals(input)) continue;
                    final JRadioButton btn = this.inputButtons[i];
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public final void run() {
                            btn.setSelected(true);
                        }
                    });
                    break;
                }
                if (i < 0) {
                    System.err.println("unknown input source from receiver: " + cmd);
                }
            } else {
                System.err.println("unhandled data from receiver: " + cmd);
            }
            System.arraycopy(data, len + 16, data, 0, datalen - len - 16);
        }
        return true;
    }

    private void showError(final String title, final String message) {
        final Main parent = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                JOptionPane.showMessageDialog(parent, message, title, 0);
            }
        });
    }

    public static void main(String[] args) {
        new Main().setVisible(true);
    }
}

